import React from 'react';
import { Card, CardContent, CardHeader, CardTitle } from '@/components/ui';
import {
  Plane,
  UserPlus,
  FileText
} from 'lucide-react';
import Link from 'next/link';

export default function QuickActions() {
  const actions = [
    {
      title: 'Yeni Bilet Talebi',
      description: 'Müşteri bilet talebi ekle',
      icon: Plane,
      href: '/tickets/new',
      color: 'bg-blue-500',
    },
    {
      title: 'Check-in Listesi',
      description: 'Otomatik check-in takibi',
      icon: FileText,
      href: '/checkin',
      color: 'bg-green-500',
    },
    {
      title: 'Yeni Müşteri',
      description: 'Müşteri bilgileri ekle',
      icon: UserPlus,
      href: '/customers/new',
      color: 'bg-purple-500',
    },
    {
      title: 'Sistem Ayarları',
      description: 'Check-in ayarları',
      icon: FileText,
      href: '/settings',
      color: 'bg-orange-500',
    },
  ];

  return (
    <Card>
      <CardHeader>
        <CardTitle>Hızlı İşlemler</CardTitle>
      </CardHeader>
      <CardContent>
        <div className="grid grid-cols-2 gap-4">
          {actions.map((action, index) => (
            <Link key={index} href={action.href}>
              <div className="group p-4 rounded-lg border border-gray-200 hover:border-gray-300 hover:shadow-md transition-all cursor-pointer">
                <div className="flex items-center space-x-3">
                  <div className={`p-2 rounded-lg ${action.color}`}>
                    <action.icon className="h-4 w-4 text-white" />
                  </div>
                  <div>
                    <h3 className="font-medium text-gray-900 group-hover:text-blue-600">
                      {action.title}
                    </h3>
                    <p className="text-sm text-gray-500">
                      {action.description}
                    </p>
                  </div>
                </div>
              </div>
            </Link>
          ))}
        </div>
      </CardContent>
    </Card>
  );
}