const mysql = require('mysql2/promise');
const bcrypt = require('bcrypt');

async function addPasswordColumn() {
  const connection = await mysql.createConnection({
    host: 'localhost',
    user: 'root',
    password: '',
    database: 'vtravel_local'
  });

  try {
    console.log('Adding password column to agency_users table...\n');

    // Add password column
    await connection.execute(`
      ALTER TABLE agency_users
      ADD COLUMN password VARCHAR(255) NULL AFTER email
    `);

    console.log('Password column added\n');

    // Hash password for Vamos admin
    const password = '34Vamos2025.';
    const hashedPassword = await bcrypt.hash(password, 10);

    console.log('Setting password for yetkili@vamos.ist...\n');

    await connection.execute(`
      UPDATE agency_users
      SET password = ?
      WHERE email = 'yetkili@vamos.ist'
    `, [hashedPassword]);

    console.log('Password set successfully!\n');

    // Verify
    const [users] = await connection.execute(`
      SELECT
        CONCAT(first_name, ' ', last_name) as name,
        email,
        CASE
          WHEN password IS NOT NULL THEN 'Set'
          ELSE 'Not Set'
        END as password_status
      FROM agency_users
      ORDER BY email
    `);

    console.log('User password status:\n');
    users.forEach(user => {
      console.log(user.name + ' | ' + user.email + ' | ' + user.password_status);
    });

  } catch (error) {
    if (error.code === 'ER_DUP_FIELDNAME') {
      console.log('Password column already exists, updating password only...\n');

      const password = '34Vamos2025.';
      const hashedPassword = await bcrypt.hash(password, 10);

      await connection.execute(`
        UPDATE agency_users
        SET password = ?
        WHERE email = 'yetkili@vamos.ist'
      `, [hashedPassword]);

      console.log('Password updated successfully!');
    } else {
      console.error('Error:', error.message);
      throw error;
    }
  } finally {
    await connection.end();
  }
}

addPasswordColumn();
