-- Migration: Create accommodation, visa, and transfer request tables
-- Date: 2025-10-21
-- Description: Add support for accommodation, visa, and transfer service requests
-- For phpMyAdmin import

-- ============================================
-- ACCOMMODATION REQUESTS TABLE
-- ============================================
DROP TABLE IF EXISTS `accommodation_requests`;
CREATE TABLE `accommodation_requests` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_type` enum('individual','corporate') COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_number` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('pending','quoted','approved','booked','confirmed','cancelled','completed') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `priority` enum('normal','high','urgent') COLLATE utf8mb4_unicode_ci DEFAULT 'normal',
  `destination_city` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `destination_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `check_in_date` date NOT NULL,
  `check_out_date` date NOT NULL,
  `nights` int NOT NULL,
  `number_of_rooms` int NOT NULL DEFAULT '1',
  `number_of_adults` int NOT NULL DEFAULT '1',
  `number_of_children` int NOT NULL DEFAULT '0',
  `room_type` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `board_type` enum('room_only','breakfast','half_board','full_board','all_inclusive') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotel_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotel_address` text COLLATE utf8mb4_unicode_ci,
  `hotel_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotel_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `hotel_rating` decimal(2,1) DEFAULT NULL,
  `hotel_confirmation_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `quoted_price` decimal(10,2) DEFAULT NULL,
  `final_price` decimal(10,2) DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'TRY',
  `special_requests` text COLLATE utf8mb4_unicode_ci,
  `meal_preferences` text COLLATE utf8mb4_unicode_ci,
  `accessibility_needs` text COLLATE utf8mb4_unicode_ci,
  `assigned_to` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_department` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed_by` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed_at` timestamp NULL DEFAULT NULL,
  `internal_notes` text COLLATE utf8mb4_unicode_ci,
  `customer_notes` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `request_number` (`request_number`),
  KEY `idx_accommodation_customer` (`customer_id`),
  KEY `idx_accommodation_status` (`status`),
  KEY `idx_accommodation_dates` (`check_in_date`,`check_out_date`),
  KEY `idx_accommodation_assigned` (`assigned_to`),
  KEY `idx_accommodation_request_number` (`request_number`),
  CONSTRAINT `accommodation_requests_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `accommodation_requests_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `agency_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- VISA REQUESTS TABLE
-- ============================================
DROP TABLE IF EXISTS `visa_requests`;
CREATE TABLE `visa_requests` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_type` enum('individual','corporate') COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_number` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('pending','documents_received','in_process','submitted','approved','rejected','cancelled','delivered') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `priority` enum('normal','high','urgent') COLLATE utf8mb4_unicode_ci DEFAULT 'normal',
  `destination_country` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `visa_type` enum('tourist','business','student','work','transit','other') COLLATE utf8mb4_unicode_ci NOT NULL,
  `purpose_of_visit` text COLLATE utf8mb4_unicode_ci,
  `planned_entry_date` date DEFAULT NULL,
  `planned_exit_date` date DEFAULT NULL,
  `duration_of_stay` int DEFAULT NULL,
  `applicant_first_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `applicant_last_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `applicant_passport_number` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `applicant_passport_expiry` date NOT NULL,
  `applicant_nationality` varchar(100) COLLATE utf8mb4_unicode_ci NOT NULL,
  `applicant_date_of_birth` date NOT NULL,
  `applicant_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `applicant_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `application_number` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `appointment_date` timestamp NULL DEFAULT NULL,
  `appointment_location` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `submitted_date` date DEFAULT NULL,
  `decision_date` date DEFAULT NULL,
  `visa_validity_start` date DEFAULT NULL,
  `visa_validity_end` date DEFAULT NULL,
  `number_of_entries` enum('single','multiple') COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `documents_required` json DEFAULT NULL,
  `documents_received` json DEFAULT NULL,
  `documents_complete` tinyint(1) DEFAULT '0',
  `service_fee` decimal(10,2) DEFAULT NULL,
  `visa_fee` decimal(10,2) DEFAULT NULL,
  `total_amount` decimal(10,2) DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'TRY',
  `payment_status` enum('unpaid','partial','paid') COLLATE utf8mb4_unicode_ci DEFAULT 'unpaid',
  `assigned_to` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_department` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed_by` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_by` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `approved_at` timestamp NULL DEFAULT NULL,
  `internal_notes` text COLLATE utf8mb4_unicode_ci,
  `customer_notes` text COLLATE utf8mb4_unicode_ci,
  `rejection_reason` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `request_number` (`request_number`),
  KEY `idx_visa_customer` (`customer_id`),
  KEY `idx_visa_status` (`status`),
  KEY `idx_visa_passport` (`applicant_passport_number`),
  KEY `idx_visa_assigned` (`assigned_to`),
  KEY `idx_visa_request_number` (`request_number`),
  KEY `idx_visa_appointment` (`appointment_date`),
  CONSTRAINT `visa_requests_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `visa_requests_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `agency_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- TRANSFER REQUESTS TABLE
-- ============================================
DROP TABLE IF EXISTS `transfer_requests`;
CREATE TABLE `transfer_requests` (
  `id` varchar(36) COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_id` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `customer_type` enum('individual','corporate') COLLATE utf8mb4_unicode_ci NOT NULL,
  `customer_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `request_number` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `status` enum('pending','assigned','confirmed','in_progress','completed','cancelled','no_show') COLLATE utf8mb4_unicode_ci DEFAULT 'pending',
  `priority` enum('normal','high','urgent') COLLATE utf8mb4_unicode_ci DEFAULT 'normal',
  `transfer_type` enum('airport_pickup','airport_dropoff','city_transfer','hourly','point_to_point') COLLATE utf8mb4_unicode_ci NOT NULL,
  `pickup_date` timestamp NOT NULL,
  `pickup_location` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `pickup_address` text COLLATE utf8mb4_unicode_ci,
  `dropoff_location` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `dropoff_address` text COLLATE utf8mb4_unicode_ci,
  `flight_number` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `airline` varchar(100) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `terminal` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `arrival_time` timestamp NULL DEFAULT NULL,
  `departure_time` timestamp NULL DEFAULT NULL,
  `number_of_passengers` int NOT NULL DEFAULT '1',
  `number_of_luggage` int DEFAULT '0',
  `passenger_name` varchar(255) COLLATE utf8mb4_unicode_ci NOT NULL,
  `passenger_phone` varchar(50) COLLATE utf8mb4_unicode_ci NOT NULL,
  `passenger_email` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `vehicle_type` enum('sedan','minivan','minibus','bus','vip','luxury') COLLATE utf8mb4_unicode_ci NOT NULL,
  `vehicle_preferences` text COLLATE utf8mb4_unicode_ci,
  `special_equipment` json DEFAULT NULL,
  `driver_name` varchar(255) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_phone` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `driver_vehicle_plate` varchar(50) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_at` timestamp NULL DEFAULT NULL,
  `quoted_price` decimal(10,2) DEFAULT NULL,
  `final_price` decimal(10,2) DEFAULT NULL,
  `currency` varchar(10) COLLATE utf8mb4_unicode_ci DEFAULT 'TRY',
  `payment_status` enum('unpaid','paid','refunded') COLLATE utf8mb4_unicode_ci DEFAULT 'unpaid',
  `driver_en_route_at` timestamp NULL DEFAULT NULL,
  `pickup_completed_at` timestamp NULL DEFAULT NULL,
  `dropoff_completed_at` timestamp NULL DEFAULT NULL,
  `actual_pickup_time` timestamp NULL DEFAULT NULL,
  `actual_dropoff_time` timestamp NULL DEFAULT NULL,
  `assigned_to` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `assigned_department` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `processed_by` varchar(36) COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `internal_notes` text COLLATE utf8mb4_unicode_ci,
  `customer_notes` text COLLATE utf8mb4_unicode_ci,
  `driver_notes` text COLLATE utf8mb4_unicode_ci,
  `special_requests` text COLLATE utf8mb4_unicode_ci,
  `created_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP,
  `updated_at` timestamp NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  PRIMARY KEY (`id`),
  UNIQUE KEY `request_number` (`request_number`),
  KEY `idx_transfer_customer` (`customer_id`),
  KEY `idx_transfer_status` (`status`),
  KEY `idx_transfer_pickup` (`pickup_date`),
  KEY `idx_transfer_assigned` (`assigned_to`),
  KEY `idx_transfer_request_number` (`request_number`),
  KEY `idx_transfer_driver` (`driver_phone`),
  CONSTRAINT `transfer_requests_ibfk_1` FOREIGN KEY (`customer_id`) REFERENCES `customers` (`id`) ON DELETE SET NULL,
  CONSTRAINT `transfer_requests_ibfk_2` FOREIGN KEY (`assigned_to`) REFERENCES `agency_users` (`id`) ON DELETE SET NULL
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;

-- ============================================
-- SAMPLE DATA FOR TESTING
-- ============================================

-- Sample Accommodation Request
INSERT INTO `accommodation_requests` (`id`, `customer_id`, `customer_type`, `customer_name`, `request_number`, `status`, `destination_city`, `destination_country`, `check_in_date`, `check_out_date`, `nights`, `number_of_rooms`, `number_of_adults`, `number_of_children`, `special_requests`)
VALUES ('acc-sample-001', NULL, 'individual', 'Ahmet Yılmaz', 'ACC-2025-001', 'pending', 'Antalya', 'Türkiye', '2025-11-01', '2025-11-04', 3, 1, 2, 1, 'Deniz manzaralı oda talep ediyorum');

-- Sample Visa Request
INSERT INTO `visa_requests` (`id`, `customer_id`, `customer_type`, `customer_name`, `request_number`, `status`, `destination_country`, `visa_type`, `applicant_first_name`, `applicant_last_name`, `applicant_passport_number`, `applicant_passport_expiry`, `applicant_nationality`, `applicant_date_of_birth`, `purpose_of_visit`)
VALUES ('visa-sample-001', NULL, 'individual', 'Ayşe Kaya', 'VISA-2025-001', 'pending', 'ABD', 'tourist', 'Ayşe', 'Kaya', 'U12345678', '2028-06-15', 'Türkiye', '1990-05-20', 'Tatil amaçlı ziyaret');

-- Sample Transfer Request
INSERT INTO `transfer_requests` (`id`, `customer_id`, `customer_type`, `customer_name`, `request_number`, `status`, `transfer_type`, `pickup_date`, `pickup_location`, `dropoff_location`, `number_of_passengers`, `passenger_name`, `passenger_phone`, `vehicle_type`)
VALUES ('trf-sample-001', NULL, 'individual', 'Mehmet Demir', 'TRF-2025-001', 'pending', 'airport_pickup', '2025-10-25 14:30:00', 'İstanbul Havalimanı', 'Taksim Meydanı', 2, 'Mehmet Demir', '+90 555 123 4567', 'sedan');
